/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.objmgr.cec;

import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.PIHscCmdMgrException;
import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.common.util.ByteUtilities;
import com.ibm.hsc.fsp.FSPCmdMgr;
import com.ibm.hsc.fsp.cmdhelpers.CodAsyncMsg;
import com.ibm.hsc.fsp.cmdhelpers.FspCecHvAvailableProcsAndMemory;
import com.ibm.hsc.fsp.cmdhelpers.FspCecHvCapabilityValues;
import com.ibm.hsc.fsp.cmdhelpers.FspCecHvConfigurableProcsAndMemory;
import com.ibm.hsc.fsp.cmdhelpers.FspCecSrcEntry;
import com.ibm.hsc.fsp.cmdhelpers.FspCmdHelper;
import com.ibm.hsc.fsp.cmdhelpers.FspCodAsyncEventData;
import com.ibm.hsc.fsp.cmdhelpers.FspCodInfo;
import com.ibm.hsc.fsp.cmdhelpers.FspLparMemory;
import com.ibm.hsc.fsp.cmdhelpers.FspProcessorPool;
import com.ibm.hsc.fsp.cmdhelpers.FspSystemCpw;
import com.ibm.hsc.fsp.cmdhelpers.SrcEntry;
import com.ibm.hsc.fsp.lockmgr.FspLockHelper;
import com.ibm.hsc.objmgr.cec.OmCecMgr;
import com.ibm.hsc.objmgr.cec.OmIoResAct;
import com.ibm.hsc.rep.RException;
import com.ibm.hsc.rep.RObject;
import com.ibm.hsc.rep.v50.R50ComputerSystem;
import java.util.BitSet;
import java.util.List;
import java.util.Vector;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;

public class OmCecInstUpdater {
    private OmCecMgr mCecMgr;
    private RObject mCecObj;
    private FspCmdHelper mFspCmdHelper;
    private FSPCmdMgr mFspCmdMgr;

    public OmCecInstUpdater(OmCecMgr omCecMgr) {
        this.mCecMgr = omCecMgr;
        this.mFspCmdHelper = this.mCecMgr.getCmdHelper();
        this.mFspCmdMgr = this.mCecMgr.getCmdMgr();
        this.mCecObj = this.mCecMgr.getObject();
    }

    public boolean isHypervisorRunning() {
        return this.mCecMgr.isHypervisorRunning();
    }

    public boolean update(FspLockHelper fspLockHelper) throws RException, PIHscServerException, PIHscCmdMgrException {
        boolean bl = false;
        UnsignedInt8 unsignedInt8 = new UnsignedInt8((short)this.mCecMgr.getCecState());
        this.mCecObj = this.mCecMgr.getObject();
        System.out.println("starting updateCecUserDefName");
        if (this.updateCecUserDefName()) {
            System.out.println("updateCecUserDefName updated");
            bl = true;
        }
        System.out.println("starting updateCecCapabilities");
        int n = this.mCecMgr.updateInterfaceCapability();
        if (n == 1 || n == 2) {
            return true;
        }
        if (n == 3) {
            System.out.println("updateCecCapabilities updated");
            bl = true;
        }
        System.out.println("starting updateCecState" + unsignedInt8);
        if (this.updateCecState(unsignedInt8)) {
            bl = true;
            System.out.println("updateCecState updated " + unsignedInt8);
        }
        System.out.println("starting updateParentMTMS");
        if (this.updateParentMTMS()) {
            bl = true;
            System.out.println("updateParentMTMS updated");
        }
        if (this.updateCecSrc()) {
            bl = true;
            System.out.println("updateCecSrc updated");
        }
        this.mCecMgr.loadSaveArea(fspLockHelper);
        if (this.mCecMgr.isHypervisorRunning()) {
            new OmIoResAct(this.mCecMgr).updateIoDrawers();
            System.out.println("[OM]starting updateCecHypervisorData");
            if (this.updateCecHypervisorData()) {
                bl = true;
                System.out.println("[OM]updateCecHypervisorData updated");
            }
            if (this.updateVirtualEthernetMACAddressPrefix()) {
                bl = true;
                System.out.println("updateVirtualEthernetMACAddressPrefix updated");
            }
        } else {
            System.out.println("TODO:  PHYP is down, so can't update the save area.  FIX THIS!!!! (432286)");
        }
        this.mCecObj.setInstance();
        return bl;
    }

    private boolean updateCecUserDefName() throws PIHscServerException, RException, PIHscCmdMgrException {
        boolean bl = false;
        String string = this.mFspCmdHelper.getCecName();
        System.out.println("new user defined name: " + string);
        if (this.mCecObj.setProperty(R50ComputerSystem.Index_UserDefinedName, (Object)string)) {
            bl = true;
            System.out.println("updated cec UserDefinedName = " + string);
        }
        return bl;
    }

    public boolean updateCecSrc() throws PIHscServerException, RException {
        String string = " ";
        try {
            FspCecSrcEntry fspCecSrcEntry = this.mFspCmdHelper.getCurrentCecSrc(false);
            List list = fspCecSrcEntry.getMSrcList();
            if (list.size() > 0) {
                SrcEntry srcEntry = (SrcEntry)list.get(0);
                string = srcEntry.getAddData();
                if ("EMPTY".equalsIgnoreCase(string)) {
                    string = " ";
                    System.out.println("Warning: OmCecInstUpdater-updateCecSrc(): We did NOT get SRC.ASCII_STRING from FSP!");
                }
            } else {
                System.out.println("Warning: OmCecInstUpdater-updateCecSrc(): We did NOT get SRC from FSP!");
            }
        }
        catch (PIHscServerException pIHscServerException) {
            if (pIHscServerException.getHscExId() == null || !pIHscServerException.getHscExId().equals("2527")) {
                System.out.println("Exception happened during updateCecSrc(): ");
                pIHscServerException.printStackTrace();
            }
        }
        catch (Exception exception) {
            System.out.println("Exception happened during updateCecSrc(): ");
            exception.printStackTrace();
        }
        return this.mCecObj.setProperty(R50ComputerSystem.Index_OpPanelValue, (Object)string);
    }

    private boolean updateCecState(UnsignedInt8 unsignedInt8) throws PIHscServerException, RException {
        boolean bl = false;
        if (this.mCecObj.setProperty(R50ComputerSystem.Index_State, (Object)unsignedInt8)) {
            bl = true;
            System.out.println("[OM]State = " + unsignedInt8);
        }
        return bl;
    }

    private boolean updateParentMTMS() throws PIHscServerException, RException, PIHscCmdMgrException {
        boolean bl = false;
        UnsignedInt8[] unsignedInt8Array = (UnsignedInt8[])this.mCecObj.getProperty(R50ComputerSystem.Index_Capability);
        byte by = unsignedInt8Array[3].byteValue();
        if ((by & 0xFFFFFF80) == 0) {
            return bl;
        }
        String[] stringArray = this.mFspCmdHelper.getStorageClusterVPD();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                System.out.println("parentMTMS[" + i + "] = " + stringArray[i]);
            }
        }
        if (this.mCecObj.setProperty(R50ComputerSystem.Index_ParentSystemModelType, (Object)stringArray[0])) {
            bl = true;
        }
        if (this.mCecObj.setProperty(R50ComputerSystem.Index_ParentSystemSerial, (Object)stringArray[1])) {
            bl = true;
        }
        if (this.mCecObj.setProperty(R50ComputerSystem.Index_MegaMouthWWNN, (Object)stringArray[2])) {
            bl = true;
        }
        if (this.mCecObj.setProperty(R50ComputerSystem.Index_MegaMouthSystemID, (Object)stringArray[3])) {
            bl = true;
        }
        if (this.mCecObj.setProperty(R50ComputerSystem.Index_MegaMouthMfgDate, (Object)stringArray[4])) {
            bl = true;
        }
        return bl;
    }

    private boolean updateVirtualEthernetMACAddressPrefix() throws PIHscServerException, RException {
        boolean bl = false;
        String string = null;
        string = this.mCecMgr.getSaveArea().getVirtEthernetMacAddrPrefix();
        if (this.mCecObj.setProperty(R50ComputerSystem.Index_VirtualEthernetMACAddressPrefix, (Object)string)) {
            bl = true;
            System.out.println("[OM]VirtualEthernetMACAddressPrefix = " + string);
        }
        return bl;
    }

    private boolean updateCodPhypData(boolean bl) throws PIHscServerException, RException {
        UnsignedInt32 unsignedInt32;
        boolean bl2 = false;
        UnsignedInt32 unsignedInt322 = this.mFspCmdHelper.getCodProcessorInfo().getTotalInstalledProcs();
        if (this.mCecObj.setProperty(R50ComputerSystem.Index_InstalledProcessors, (Object)unsignedInt322)) {
            bl2 = true;
            System.out.println("[OM]InstalledProcessors = " + Long.toHexString(unsignedInt322.longValue()));
        }
        if (this.mCecObj.setProperty(R50ComputerSystem.Index_InstalledMemory, (Object)(unsignedInt32 = this.mFspCmdHelper.getCodMemoryInfo().getTotalInstalledMem()))) {
            bl2 = true;
            System.out.println("[OM]InstalledMemory = " + Long.toHexString(unsignedInt32.longValue()));
        }
        UnsignedInt32 unsignedInt323 = new UnsignedInt32(0L);
        BitSet bitSet = null;
        if (bl) {
            bitSet = this.mFspCmdHelper.getCodCapabilities();
            unsignedInt323 = ByteUtilities.bitSetToUnsignedInt32(bitSet);
        }
        if (this.mCecObj.setProperty(R50ComputerSystem.Index_CodCapabilities, (Object)unsignedInt323)) {
            bl2 = true;
            System.out.println("[OM]CodCapabilities = " + Long.toHexString(unsignedInt323.longValue()));
        }
        if (!bl) {
            return bl2;
        }
        boolean bl3 = false;
        if (this.updateCecCodAsyncMsgList(bl3, null)) {
            bl2 = true;
        }
        if (this.updateCecCodOnoffProcState(bitSet.get(6))) {
            bl2 = true;
        }
        if (this.updateCecCodOnoffMemState(bitSet.get(7))) {
            bl2 = true;
        }
        if (this.updateCecCodMeteredProcState(bitSet.get(2))) {
            bl2 = true;
        }
        if (this.updateCecCodTrialProcState(bitSet.get(4))) {
            bl2 = true;
        }
        if (this.updateCecCodTrialMemState(bitSet.get(5))) {
            bl2 = true;
        }
        if (this.updateCecCodCodeCompleteStatus(0)) {
            bl2 = true;
        }
        if (this.updateCodIncrements()) {
            bl2 = true;
        }
        return bl2;
    }

    private boolean updateFoDPhypData(boolean bl) throws PIHscServerException, RException {
        boolean bl2 = false;
        UnsignedInt32 unsignedInt32 = new UnsignedInt32(0L);
        if (bl) {
            BitSet bitSet = this.mFspCmdHelper.getFoDCapabilities();
            System.out.println("FoD caps bit set: " + bitSet);
            unsignedInt32 = ByteUtilities.bitSetToUnsignedInt32(bitSet);
        }
        if (this.mCecObj.setProperty(R50ComputerSystem.Index_FoDCapabilities, (Object)unsignedInt32)) {
            bl2 = true;
            System.out.println("[OM]FoDCapabilities = " + Long.toHexString(unsignedInt32.longValue()));
        }
        return bl2;
    }

    private boolean updateCodIncrements() throws PIHscServerException, RException {
        boolean bl = false;
        FspCodInfo fspCodInfo = this.mFspCmdHelper.getActivationIncrements();
        UnsignedInt16 unsignedInt16 = fspCodInfo.getOnoffProcIncrement();
        UnsignedInt16 unsignedInt162 = fspCodInfo.getMeteredProcIncrement();
        UnsignedInt16 unsignedInt163 = fspCodInfo.getOnoffMemoryIncrement();
        if (this.mCecObj.setProperty(R50ComputerSystem.Index_OnoffCodProcIncrement, (Object)unsignedInt16)) {
            bl = true;
            System.out.println("[OM]OnoffCodProcIncrement = " + Long.toHexString(unsignedInt16.longValue()));
        }
        if (this.mCecObj.setProperty(R50ComputerSystem.Index_MeteredCodProcIncrement, (Object)unsignedInt162)) {
            bl = true;
            System.out.println("[OM]MeteredCodProcIncrement = " + Long.toHexString(unsignedInt162.longValue()));
        }
        if (this.mCecObj.setProperty(R50ComputerSystem.Index_OnoffCodMemIncrement, (Object)unsignedInt163)) {
            bl = true;
            System.out.println("[OM]OnoffCodMemIncrement = " + Long.toHexString(unsignedInt163.longValue()));
        }
        return bl;
    }

    public boolean updateCecHypervisorStateData(boolean bl) throws PIHscServerException, RException, PIHscCmdMgrException {
        UnsignedInt16 unsignedInt16;
        BitSet bitSet;
        UnsignedInt32 unsignedInt32;
        boolean bl2 = false;
        UnsignedInt16 unsignedInt162 = this.mFspCmdHelper.getNumberOfLparSlots();
        if (this.mCecObj.setProperty(R50ComputerSystem.Index_NumLPARSlots, (Object)unsignedInt162)) {
            bl2 = true;
            System.out.println("[OM]NumLPARSlots = " + unsignedInt162);
        }
        if (this.mCecObj.setProperty(R50ComputerSystem.Index_RuntimeCapability, (Object)(unsignedInt32 = ByteUtilities.bitSetToUnsignedInt32(bitSet = this.mFspCmdHelper.getHypervisorCapabilities())))) {
            bl2 = true;
            System.out.println("[OM]RuntimeCapability = " + Long.toHexString(unsignedInt32.longValue()));
        }
        if (!bl) {
            if (this.updateCodPhypData(bitSet.get(29))) {
                bl2 = true;
            }
            if (this.updateFoDPhypData(bitSet.get(26))) {
                bl2 = true;
            }
        }
        if (this.updatePhypCapValues()) {
            bl2 = true;
        }
        if (this.mCecObj.setProperty(R50ComputerSystem.Index_MaxVLANIDsPerPort, (Object)(unsignedInt16 = this.mFspCmdHelper.getVirtualIoCapabilities()))) {
            bl2 = true;
            System.out.println("[OM]MaxVLANIDsPerPort = " + unsignedInt16);
        }
        return bl2;
    }

    private boolean updatePhypCapValues() throws PIHscServerException, RException, PIHscCmdMgrException {
        boolean bl = false;
        FspCecHvCapabilityValues fspCecHvCapabilityValues = this.mFspCmdHelper.getHypervisorCapabilityValues();
        this.mCecMgr.setRecommandedHptRatio(fspCecHvCapabilityValues.getRecommendedHptRatio());
        if (this.mCecObj.setProperty(R50ComputerSystem.Index_LMBSize, (Object)fspCecHvCapabilityValues.getLMBSize())) {
            bl = true;
            System.out.println("[OM]LMBSize = " + fspCecHvCapabilityValues.getLMBSize());
        }
        if (this.mCecObj.setProperty(R50ComputerSystem.Index_MaxHostingLpars, (Object)fspCecHvCapabilityValues.getMaxHostingLpars())) {
            bl = true;
            System.out.println("[OM]MaxHostingLpars = " + fspCecHvCapabilityValues.getMaxHostingLpars());
        }
        if (this.mCecObj.setProperty(R50ComputerSystem.Index_MinProcUnit, (Object)fspCecHvCapabilityValues.getMinProcUnit())) {
            bl = true;
            System.out.println("[OM]MinProcUnit = " + fspCecHvCapabilityValues.getMinProcUnit());
        }
        if (this.mCecObj.setProperty(R50ComputerSystem.Index_MaxProcPools, (Object)fspCecHvCapabilityValues.getMaxProcPools())) {
            bl = true;
            System.out.println("[OM]MaxProcPools = " + fspCecHvCapabilityValues.getMaxProcPools());
        }
        if (this.mCecObj.setProperty(R50ComputerSystem.Index_MaxNumberOfIoPools, (Object)fspCecHvCapabilityValues.getMaxIoPoolNum())) {
            bl = true;
            System.out.println("[OM]MaxNumberOfIoPools = " + fspCecHvCapabilityValues.getMaxIoPoolNum());
        }
        if (this.mCecObj.setProperty(R50ComputerSystem.Index_MaxVirProcPerPartition, (Object)fspCecHvCapabilityValues.getMaxVirProcPerLpartition())) {
            bl = true;
            System.out.println("[OM]MaxVirProcPerPartition = " + fspCecHvCapabilityValues.getMaxVirProcPerLpartition());
        }
        if (this.mCecObj.setProperty(R50ComputerSystem.Index_MaxDedicatedProcPerPartition, (Object)fspCecHvCapabilityValues.getMaxDedicateProcsPerLpar())) {
            bl = true;
            System.out.println("[OM]MaxDedicatedProcPerPartition = " + fspCecHvCapabilityValues.getMaxDedicateProcsPerLpar());
        }
        if (this.mCecObj.setProperty(R50ComputerSystem.Index_MaxVirOptiPools, (Object)fspCecHvCapabilityValues.getMaxVirOpti())) {
            bl = true;
            System.out.println("[OM]MaxVirOptiPools = " + fspCecHvCapabilityValues.getMaxVirOpti());
        }
        if (this.mCecObj.setProperty(R50ComputerSystem.Index_MaxHSLOptiPools, (Object)fspCecHvCapabilityValues.getMaxHslOpti())) {
            bl = true;
            System.out.println("[OM]MaxHSLOptiPools = " + fspCecHvCapabilityValues.getMaxHslOpti());
        }
        return bl;
    }

    public boolean updatePhypAvailResData() throws PIHscServerException, RException {
        UnsignedInt32 unsignedInt32;
        FspProcessorPool fspProcessorPool;
        UnsignedInt32 unsignedInt322;
        long l;
        long l2;
        long l3;
        UnsignedInt16 unsignedInt16;
        BitSet bitSet;
        boolean bl = false;
        FspLparMemory fspLparMemory = this.mFspCmdHelper.getCurrAndPendLparMem(new UnsignedInt16(0));
        UnsignedInt16 unsignedInt162 = (UnsignedInt16)this.mCecObj.getProperty(R50ComputerSystem.Index_LMBSize);
        UnsignedInt32 unsignedInt323 = new UnsignedInt32(fspLparMemory.getCurAllocMem().longValue() * unsignedInt162.longValue());
        if (this.mCecObj.setProperty(R50ComputerSystem.Index_HypervisorMemoryUsage, (Object)unsignedInt323)) {
            bl = true;
            System.out.println("HypervisorMemoryUsage = " + unsignedInt323 + "MB");
        }
        FspCecHvConfigurableProcsAndMemory fspCecHvConfigurableProcsAndMemory = this.mFspCmdHelper.getHypervisorConfigurableProcsAndMemory();
        FspCecHvAvailableProcsAndMemory fspCecHvAvailableProcsAndMemory = this.mFspCmdHelper.getHypervisorAvailableProcsAndMemory();
        UnsignedInt32 unsignedInt324 = fspCecHvConfigurableProcsAndMemory.getConfigurableProcUnits();
        if (this.mCecObj.setProperty(R50ComputerSystem.Index_ConfigurableProcUnits, (Object)unsignedInt324)) {
            bl = true;
            System.out.println("[OM]ConfigurableProcUnits = " + unsignedInt324);
        }
        if ((bitSet = this.mFspCmdHelper.getHypervisorCapabilities()).get(30) && this.mCecObj.setProperty(R50ComputerSystem.Index_MaxI5OSProcUnits, (Object)(unsignedInt16 = this.mFspCmdHelper.getOS400Capacity()))) {
            bl = true;
            System.out.println("[OM]MaxI5OSProcUnits = " + unsignedInt16);
        }
        if (this.mCecObj.setProperty(R50ComputerSystem.Index_ConfigurableMem, (Object)new UnsignedInt32(l3 = fspCecHvConfigurableProcsAndMemory.getConfigurableMem().longValue() * unsignedInt162.longValue()))) {
            bl = true;
            System.out.println("[OM]ConfigurableMem = " + l3);
        }
        if (this.mCecObj.setProperty(R50ComputerSystem.Index_CurAvailMem, (Object)new UnsignedInt32(l2 = fspCecHvAvailableProcsAndMemory.getCurAvailMem().longValue() * unsignedInt162.longValue()))) {
            bl = true;
            System.out.println("[OM]CurAvailMem = " + l2);
        }
        if (this.mCecObj.setProperty(R50ComputerSystem.Index_PendAvailMem, (Object)new UnsignedInt32(l = fspCecHvAvailableProcsAndMemory.getPendAvailMem().longValue() * unsignedInt162.longValue()))) {
            bl = true;
            System.out.println("[OM]PendAvailMem = " + l);
        }
        if (this.mCecObj.setProperty(R50ComputerSystem.Index_CurAvailProcUnits, (Object)(unsignedInt322 = (fspProcessorPool = this.mFspCmdHelper.getSharedProcessingResources(new UnsignedInt8(0))).getCurAvailableProcUnits()))) {
            bl = true;
            System.out.println("[OM]CurAvailProcUnits = " + unsignedInt322);
        }
        if (this.mCecObj.setProperty(R50ComputerSystem.Index_PendAvailProcUnits, (Object)(unsignedInt32 = fspProcessorPool.getPendAvailableProcUnits()))) {
            bl = true;
            System.out.println("[OM]PendAvailProcUnits = " + unsignedInt32);
        }
        if (this.mCecObj.setProperty(R50ComputerSystem.Index_CurAvailInteractive, (Object)fspCecHvAvailableProcsAndMemory.getCurAvailInteractive())) {
            bl = true;
            System.out.println("[OM]CurAvailInteractive = " + fspCecHvAvailableProcsAndMemory.getCurAvailInteractive());
        }
        if (this.mCecObj.setProperty(R50ComputerSystem.Index_PendAvailInteractive, (Object)fspCecHvAvailableProcsAndMemory.getPendAvailInteractive())) {
            bl = true;
            System.out.println("[OM]PendAvailInteractive = " + fspCecHvAvailableProcsAndMemory.getPendAvailInteractive());
        }
        return bl;
    }

    public boolean updateCecHypervisorData() throws PIHscServerException, RException, PIHscCmdMgrException {
        boolean bl = false;
        if (this.updateCecHypervisorStateData(false)) {
            bl = true;
        }
        if (this.updateSystemCpw()) {
            bl = true;
        }
        if (this.updateCecHypervisorStateData(false)) {
            bl = true;
        }
        if (this.updatePhypAvailResData()) {
            bl = true;
        }
        System.out.println("&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&");
        System.out.println("&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&");
        System.out.println("");
        System.out.println("TODO: FIX THIS.  We must put the Code Update stuff");
        System.out.println("                 in the right place!!!!!");
        System.out.println(" - Talk to Amartey - ");
        System.out.println("&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&");
        System.out.println("&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&");
        Boolean bl2 = new Boolean(true);
        if (this.mCecObj.setProperty(R50ComputerSystem.Index_PartCodeLidUpdateSupported, (Object)bl2)) {
            bl = true;
            System.out.println("[OM]PartCodeLidUpdateSupported = " + bl2);
        }
        return bl;
    }

    public boolean updateCecCodCodeCompleteStatus(int n) throws PIHscServerException, RException {
        UnsignedInt8 unsignedInt8 = new UnsignedInt8((short)n);
        System.out.println("[OM]CodCodeCompleteStatus = " + Long.toHexString(unsignedInt8.longValue()));
        return this.mCecObj.setProperty(R50ComputerSystem.Index_CodCodeCompleteStatus, (Object)unsignedInt8);
    }

    public boolean updateCecCodOnoffProcState(boolean bl) throws PIHscServerException, RException {
        UnsignedInt8 unsignedInt8 = null;
        unsignedInt8 = bl ? this.mFspCmdHelper.getOnoffCodProcessorInfo().getOnoffProcState() : new UnsignedInt8(255);
        System.out.println("[OM]OnoffCodProcState = " + Long.toHexString(unsignedInt8.longValue()));
        return this.mCecObj.setProperty(R50ComputerSystem.Index_OnoffCodProcState, (Object)unsignedInt8);
    }

    public boolean updateCecCodOnoffMemState(boolean bl) throws PIHscServerException, RException {
        UnsignedInt8 unsignedInt8 = null;
        unsignedInt8 = bl ? this.mFspCmdHelper.getOnoffCodMemoryInfo().getOnoffMemState() : new UnsignedInt8(255);
        System.out.println("[OM]OnoffCodMemState = " + Long.toHexString(unsignedInt8.longValue()));
        return this.mCecObj.setProperty(R50ComputerSystem.Index_OnoffCodMemState, (Object)unsignedInt8);
    }

    public boolean updateCecCodMeteredProcState(boolean bl) throws PIHscServerException, RException {
        UnsignedInt8 unsignedInt8 = null;
        unsignedInt8 = bl ? this.mFspCmdHelper.getMeteredCodProcessorInfo().getMeteredProcState() : new UnsignedInt8(255);
        System.out.println("[OM]MeteredCodProcState = " + Long.toHexString(unsignedInt8.longValue()));
        return this.mCecObj.setProperty(R50ComputerSystem.Index_MeteredCodProcState, (Object)unsignedInt8);
    }

    public boolean updateCecCodTrialProcState(boolean bl) throws PIHscServerException, RException {
        UnsignedInt8 unsignedInt8 = null;
        unsignedInt8 = bl ? this.mFspCmdHelper.getTrialCodProcessorInfo().getTrialProcState() : new UnsignedInt8(255);
        System.out.println("[OM]TrialCodProcState = " + Long.toHexString(unsignedInt8.longValue()));
        return this.mCecObj.setProperty(R50ComputerSystem.Index_TrialCodProcState, (Object)unsignedInt8);
    }

    public boolean updateCecCodTrialMemState(boolean bl) throws PIHscServerException, RException {
        UnsignedInt8 unsignedInt8 = null;
        unsignedInt8 = bl ? this.mFspCmdHelper.getTrialCodMemoryInfo().getTrialMemState() : new UnsignedInt8(255);
        System.out.println("[OM]TrialCodMemState = " + Long.toHexString(unsignedInt8.longValue()));
        return this.mCecObj.setProperty(R50ComputerSystem.Index_TrialCodMemState, (Object)unsignedInt8);
    }

    public boolean updateSystemCpw() throws PIHscServerException, RException {
        boolean bl = false;
        try {
            FspSystemCpw fspSystemCpw = this.mFspCmdHelper.getSystemCpw();
            if (this.mCecObj.setProperty(R50ComputerSystem.Index_TotalBatchCPW, (Object)fspSystemCpw.getTotalCpw())) {
                System.out.println("[OM]TotalBatchCPW = " + fspSystemCpw.getTotalCpw());
                bl = true;
            }
            if (this.mCecObj.setProperty(R50ComputerSystem.Index_TotalInteractiveCPW, (Object)fspSystemCpw.getInteractiveCpw())) {
                System.out.println("[OM]TotalInteractiveCPW = " + fspSystemCpw.getInteractiveCpw());
                bl = true;
            }
            Boolean bl2 = new Boolean(false);
            UnsignedInt8 unsignedInt8 = fspSystemCpw.getAllowHmcAssignInteractive();
            if (unsignedInt8 != null && unsignedInt8.intValue() != 0) {
                bl2 = new Boolean(true);
            }
            if (this.mCecObj.setProperty(R50ComputerSystem.Index_AllowHmcAssignInteractive, (Object)bl2)) {
                System.out.println("[OM]AllowHmcAssignInteractive = " + bl2);
                bl = true;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return bl;
    }

    public boolean updateCecCodAsyncMsgList(boolean bl, FspCodAsyncEventData fspCodAsyncEventData) throws PIHscServerException, RException {
        Vector<String> vector = new Vector<String>();
        CodAsyncMsg[] codAsyncMsgArray = null;
        if (bl && fspCodAsyncEventData != null) {
            int n;
            int n2 = fspCodAsyncEventData.getMsgListLength().intValue();
            if (n2 > 0) {
                codAsyncMsgArray = fspCodAsyncEventData.getMsgList();
            }
            for (n = 0; n < n2; ++n) {
                String string;
                int n3;
                short s = codAsyncMsgArray[n].getMessageId().shortValue();
                int n4 = codAsyncMsgArray[n].getMessageDestination().intValue();
                byte[] byArray = ByteUtilities.intToByteArray(n4);
                BitSet bitSet = ByteUtilities.byteArrayToBitSet(byArray);
                int n5 = codAsyncMsgArray[n].getNumberOfMsgParms().intValue();
                if (!bitSet.get(0)) continue;
                String string2 = "";
                if (s == 0) {
                    string2 = "0000";
                } else {
                    n3 = 3;
                    int n6 = 10;
                    while (s / n6 > 0) {
                        --n3;
                        n6 *= 10;
                    }
                    string2 = "";
                    while (n3 != 0) {
                        string2 = string2 + "0";
                        --n3;
                    }
                    string2 = string2 + Integer.toString(s);
                }
                if (n5 > 0) {
                    UnsignedInt16[] unsignedInt16Array = codAsyncMsgArray[n].getMessageParms();
                    String[] stringArray = new String[n5];
                    for (n3 = 0; n3 < n5; ++n3) {
                        stringArray[n3] = unsignedInt16Array[n3].toString();
                    }
                    string = HSCResourceBundleUtil.encodeNLSMsg("CoDMsgBundle", string2, "", stringArray);
                } else {
                    string = HSCResourceBundleUtil.encodeNLSMsg("CoDMsgBundle", string2, "");
                }
                vector.add(string);
            }
            for (n = 0; n < n2; ++n) {
                System.out.println("[OM]CodAsyncMsgList[" + n + "] = " + vector.elementAt(n));
            }
        }
        return this.mCecObj.setProperty(R50ComputerSystem.Index_CodAsyncMsgList, vector);
    }

    public boolean updatePhypAvailMemData() throws PIHscServerException, RException {
        long l;
        boolean bl = false;
        FspLparMemory fspLparMemory = this.mFspCmdHelper.getCurrAndPendLparMem(new UnsignedInt16(0));
        UnsignedInt16 unsignedInt16 = (UnsignedInt16)this.mCecObj.getProperty(R50ComputerSystem.Index_LMBSize);
        UnsignedInt32 unsignedInt32 = new UnsignedInt32(fspLparMemory.getCurAllocMem().longValue() * unsignedInt16.longValue());
        if (this.mCecObj.setProperty(R50ComputerSystem.Index_HypervisorMemoryUsage, (Object)unsignedInt32)) {
            bl = true;
            System.out.println("HypervisorMemoryUsage = " + unsignedInt32 + "MB");
        }
        FspCecHvConfigurableProcsAndMemory fspCecHvConfigurableProcsAndMemory = this.mFspCmdHelper.getHypervisorConfigurableProcsAndMemory();
        FspCecHvAvailableProcsAndMemory fspCecHvAvailableProcsAndMemory = this.mFspCmdHelper.getHypervisorAvailableProcsAndMemory();
        long l2 = fspCecHvAvailableProcsAndMemory.getCurAvailMem().longValue() * unsignedInt16.longValue();
        if (this.mCecObj.setProperty(R50ComputerSystem.Index_CurAvailMem, (Object)new UnsignedInt32(l2))) {
            bl = true;
            System.out.println("[OM]CurAvailMem = " + l2);
        }
        if (this.mCecObj.setProperty(R50ComputerSystem.Index_PendAvailMem, (Object)new UnsignedInt32(l = fspCecHvAvailableProcsAndMemory.getPendAvailMem().longValue() * unsignedInt16.longValue()))) {
            bl = true;
            System.out.println("[OM]PendAvailMem = " + l);
        }
        return bl;
    }

    public boolean updatePhypAvailProcData() throws PIHscServerException, RException {
        UnsignedInt32 unsignedInt32;
        FspProcessorPool fspProcessorPool;
        UnsignedInt32 unsignedInt322;
        boolean bl = false;
        FspCecHvConfigurableProcsAndMemory fspCecHvConfigurableProcsAndMemory = this.mFspCmdHelper.getHypervisorConfigurableProcsAndMemory();
        FspCecHvAvailableProcsAndMemory fspCecHvAvailableProcsAndMemory = this.mFspCmdHelper.getHypervisorAvailableProcsAndMemory();
        UnsignedInt32 unsignedInt323 = fspCecHvConfigurableProcsAndMemory.getConfigurableProcUnits();
        if (this.mCecObj.setProperty(R50ComputerSystem.Index_ConfigurableProcUnits, (Object)unsignedInt323)) {
            bl = true;
            System.out.println("[OM]ConfigurableProcUnits = " + unsignedInt323);
        }
        if (this.mCecObj.setProperty(R50ComputerSystem.Index_CurAvailProcUnits, (Object)(unsignedInt322 = (fspProcessorPool = this.mFspCmdHelper.getSharedProcessingResources(new UnsignedInt8(0))).getCurAvailableProcUnits()))) {
            bl = true;
            System.out.println("[OM]CurAvailProcUnits = " + unsignedInt322);
        }
        if (this.mCecObj.setProperty(R50ComputerSystem.Index_PendAvailProcUnits, (Object)(unsignedInt32 = fspProcessorPool.getPendAvailableProcUnits()))) {
            bl = true;
            System.out.println("[OM]PendAvailProcUnits = " + unsignedInt32);
        }
        if (this.mCecObj.setProperty(R50ComputerSystem.Index_CurAvailInteractive, (Object)fspCecHvAvailableProcsAndMemory.getCurAvailInteractive())) {
            bl = true;
            System.out.println("[OM]CurAvailInteractive = " + fspCecHvAvailableProcsAndMemory.getCurAvailInteractive());
        }
        if (this.mCecObj.setProperty(R50ComputerSystem.Index_PendAvailInteractive, (Object)fspCecHvAvailableProcsAndMemory.getPendAvailInteractive())) {
            bl = true;
            System.out.println("[OM]PendAvailInteractive = " + fspCecHvAvailableProcsAndMemory.getPendAvailInteractive());
        }
        return bl;
    }
}

